/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.client.renderer.CustomLayeredTexture;
import sekelsta.horse_colors.client.renderer.HorseArmorLayer;
import sekelsta.horse_colors.client.renderer.HorseGeneticModel;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;

@OnlyIn(value=Dist.CLIENT)
public class HorseGeneticRenderer
extends MobRenderer<AbstractHorseGenetic, HorseGeneticModel<AbstractHorseGenetic>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    protected void scale(AbstractHorseGenetic horse, MatrixStack matrixStackIn, float partialTickTime) {
        float scale = horse.getProportionalAgeScale();
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.field_76989_e = 0.75f * scale;
        super.func_225620_a_((LivingEntity)horse, matrixStackIn, partialTickTime);
    }

    public HorseGeneticRenderer(EntityRendererManager renderManager) {
        super(renderManager, new HorseGeneticModel(0.0f), 0.75f);
        this.func_177094_a(new HorseArmorLayer((IEntityRenderer<AbstractHorseGenetic, HorseGeneticModel<AbstractHorseGenetic>>)this));
    }

    public ResourceLocation getTextureLocation(AbstractHorseGenetic entity) {
        if (entity instanceof IGeneticEntity) {
            String s = entity.getGenome().getTexture();
            ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourcelocation, (Texture)new CustomLayeredTexture(entity.getGenome().getTexturePaths()));
                LAYERED_LOCATION_CACHE.put(s, resourcelocation);
            }
            return resourcelocation;
        }
        System.out.println("Trying to render an ineligible entity");
        return null;
    }
}

